<#ibiztemplate>
TARGET=PSSYSTEM
</#ibiztemplate>
package ${pub.getPKGCodeName()}.util.service;


import ${pub.getPKGCodeName()}.util.errors.BadRequestAlertException;
import ${pub.getPKGCodeName()}.util.security.AuthenticationUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Service;


public interface AuthenticationUserService extends UserDetailsService {

<#if sys.getPSSystemSetting()?? && sys.getPSSystemSetting().getDataAccCtrlArch()?? && sys.getPSSystemSetting().getDataAccCtrlArch()==1>
    <#assign cachename="ibzuaa_users">
<#else >
    <#assign cachename=pub.getCodeName()?lower_case+"_users">
</#if>

    @Override
    @Cacheable( value="${cachename}", key = "'getByUsername:'+#p0")
    AuthenticationUser loadUserByUsername(String username);

    @Cacheable( value="${cachename}", key = "'getByUsername:'+#p0")
    AuthenticationUser loadUserByLogin(String username,String password);

    @CacheEvict( value="${cachename}", key = "'getByUsername:'+#p0")
    void resetByUsername(String username);
}
